/*
 * Decompiled with CFR 0.152.
 */
package com.dinzeer.legendblade.network;

import com.dinzeer.legendblade.entity.DemonBladeFragments;
import com.dinzeer.legendblade.regsitry.other.LBEntiteRegristrys;
import com.exfantasy.mclib.Utils.SlashBlade.SlashbladeUtils;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class DemonBladeMessage {
    private final int entityId;

    public DemonBladeMessage(int entityId) {
        this.entityId = entityId;
    }

    public DemonBladeMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
    }

    public static void handle(DemonBladeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        LogicalSide side = context.getDirection().getReceptionSide();
        if (side == LogicalSide.SERVER) {
            context.enqueueWork(() -> DemonBladeMessage.apply((LivingEntity)context.getSender()));
        }
        ctx.get().setPacketHandled(true);
    }

    public static void apply(LivingEntity entity) {
        ItemStack stack = entity.m_21205_();
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !SlashbladeUtils.getStringNBT(tag, "translationKey").equals("item.legendblade.sevensword")) {
            return;
        }
        BlockPos center = entity.m_20097_();
        Level level = entity.m_9236_();
        List<Entity> entitiesFound = level.m_6443_(Entity.class, new AABB(center).m_82400_(2.0), a -> true).stream().sorted(Comparator.comparingDouble(ent -> ent.m_20238_(center.m_252807_()))).toList();
        boolean hasFragments = false;
        for (Entity entity2 : entitiesFound) {
            DemonBladeFragments demonBladeFragments;
            if (!(entity2 instanceof DemonBladeFragments) || (demonBladeFragments = (DemonBladeFragments)entity2).isBack()) continue;
            demonBladeFragments.setFire(true);
            hasFragments = true;
        }
        if (!hasFragments) {
            int count = 15;
            for (int i = 0; i < count; ++i) {
                int colorCode = entity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getColorCode()).orElse(-13421569);
                DemonBladeFragments ss = new DemonBladeFragments(LBEntiteRegristrys.dbf, level);
                level.m_7967_((Entity)ss);
                ss.setSpeed(2.2f);
                ss.setIsCritical(false);
                ss.m_5602_((Entity)entity);
                ss.setColor(colorCode);
                ss.setRoll(0.0f);
                ss.setDamage(entity.m_21133_(Attributes.f_22281_) * (double)1.9f);
                ss.m_7998_((Entity)entity, true);
                ss.setDelay(40);
                boolean isRight = i % 2 == 0;
                RandomSource random = level.m_213780_();
                double xOffset = random.m_188500_() * 2.5 * (double)(isRight ? 1 : -1);
                double yOffset = random.m_188501_() * 2.0f;
                double zOffset = (double)random.m_188501_() * 0.5;
                ss.m_146884_(entity.m_20182_().m_82520_(xOffset, yOffset, zOffset));
                ss.setOffset(new Vec3(xOffset, yOffset, zOffset));
                entity.m_5496_(SoundEvents.f_11757_, 0.2f, 1.45f);
            }
        }
    }
}

